// Import the Next Head element for supplying metadata, etc.
import Head from 'next/head'

// Import the React modules for state variables and effects.
import {useState, useEffect} from 'react'

// Define the home page function. The function needs to load
// data and define its display.
export default function Home() {
  // Initialize a React state variable for the home page data.
  const [homeData, setHomeData] = useState([]);

  // Load the home page data from the Next API endpoint.
  useEffect(() => {
    fetch('/api/home')
      .then((res) => res.json())
      .then((data) => setHomeData(data))
  }, [])

  // Render the page template.
  return (
    <div>
      <Head>
        <title>{homeData.name}</title>
        <meta name='description' content='Generated by create next app' />
        <link rel='icon' href='/favicon.ico' />
      </Head>

      <div className="text-center align-middle">
        <h1 className="text-xl">
          {homeData.name}
        </h1>
      </div>

      <div>
        <div className="m-2">
          <p>{homeData.description}</p>
        </div>
        <div className="m-2">
          <p>Take a look at <a className="underline decoration-blue-400 decoration-dashed" href="/posts">the blog</a>!</p>
        </div>
      </div>
    </div>
  )
}

